<?php
/**
 * Plugin Name: R6 Kitchen Sink
 * Description: A collection of useful functionality for websites developed by R6 Digital.
 * Version:     2.0.12
 * Author:      R6 Digital
 * Author URI:  https://r6digital.com.au
 */

namespace R6Digital\KitchenSink;

define('R6_KITCHEN_SINK_URL', plugin_dir_url(__FILE__));
define('R6_KITCHEN_SINK_PATH', plugin_dir_path(__FILE__));
define('R6_KITCHEN_SINK_ID', 'r6_kitchen_sink'); // never change this
define('R6_KITCHEN_SINK_NAME', 'R6 Kitchen Sink');
define('R6_KITCHEN_SINK_VERSION', '2.0.12');

add_action('plugins_loaded', function () {
    if (file_exists($autoload = __DIR__ . '/vendor/autoload.php')) {
        require_once $autoload;
    }

    \Puc_v4_Factory::buildUpdateChecker(
        'https://wp-plugin-repo.r6internal.com/?action=get_metadata&slug=r6-kitchen-sink',
        __FILE__,
        'r6-kitchen-sink'
    );

    new Authentication();
    new Branding();
    new Compatibility();
    new SettingsPage();
    new UrlParameterTracking();
    new WPCF7();
    Performance::instance()->init();
    new Health\MissingMedia404();
});
