<?php

namespace R6Digital\KitchenSink;

class Branding
{
    public function __construct()
    {
        if (self::show_on_login()) {
            add_action('login_enqueue_scripts', [$this, 'add_login_css']);
        }

        if (self::show_in_admin()) {
            add_action('admin_init', [$this, 'add_admin_theme']);
            add_action('admin_bar_menu', [$this, 'add_link_to_dropdown'], 20 );
            add_filter('get_user_option_admin_color', [$this, 'force_selected_theme'], 10, 0);
            remove_action('admin_color_scheme_picker', 'admin_color_scheme_picker');
        }
    }

    public static function show_on_login(): bool
    {
        return get_option(R6_KITCHEN_SINK_ID . '_branding_login', true) && !Compatibility::is_incompatible_r6_styles_active();
    }

    public static function show_in_admin(): bool
    {
        return get_option(R6_KITCHEN_SINK_ID . '_branding_admin', true) && !Compatibility::is_incompatible_r6_styles_active();
    }

    public function add_login_css()
    {
        wp_enqueue_style(R6_KITCHEN_SINK_ID . '_branding_login', R6_KITCHEN_SINK_URL . 'assets/css/login.css');
    }

    public function add_admin_theme()
    {
        wp_admin_css_color(
            R6_KITCHEN_SINK_ID,
            R6_KITCHEN_SINK_NAME,
            R6_KITCHEN_SINK_URL . '/assets/css/admin.css',
            [ '#000000',  '#FFFF00', '#FFFFFF', '#000000' ],
            [ 'base' => '#FFFFFF', 'focus' => '#FFFF00', 'current' => '#000000' ]
        );
    }

    public function add_link_to_dropdown($wp_admin_bar)
    {
        $wp_admin_bar->add_node(
            [
                'parent' => 'wp-logo',
                'id'     => R6_KITCHEN_SINK_ID,
                'title'  => 'R6 Digital',
                'href'   => 'https://r6digital.com.au',
            ]
        );
    }

    public function force_selected_theme()
    {
        return R6_KITCHEN_SINK_ID;
    }
}
