<?php

namespace R6Digital\KitchenSink;

class Compatibility
{
    public function __construct()
    {
        add_filter('r6_styles_show_custom_login', '__return_false');
        add_filter('r6_styles_admin_branding', '__return_false');
    }

    public static function is_wordpress_social_login_active(): bool
    {
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

        return is_plugin_active('wordpress-social-login-r6/wp-social-login-r6.php');
    }

    public static function is_incompatible_r6_styles_active(): bool
    {
        // If the class doesn't exist, the plugin isn't installed at all
        if (!class_exists('R6Styles')) {
            return false;
        }

        // Any version of the plugin without the VERSION constant is incompatible
        if (!defined('R6_STYLES_VERSION')) {
            return true;
        }

        return version_compare(R6_STYLES_VERSION, '1.3.2', '<');
    }
}
