<?php

namespace R6Digital\KitchenSink\Performance;

class DisableAvadaSvg extends Module
{
    public function is_available(): bool
    {
        return class_exists('Avada');
    }

    public function get_name(): string
    {
        return 'Avada: Disable SVG Fix';
    }

    public function get_description(): string
    {
        return 'Highly Recommended. Avada will read SVG files in the media library from disk in an attempt to determine their width and height, causing severe performance degradation.';
    }

    public function get_unavailable_message(): string
    {
        return 'Avada is not installed.';
    }

    public function run(): void
    {
        add_action('init', [$this, 'remove_hooks']);
    }

    public function remove_hooks()
    {
        remove_filter('wp_get_attachment_image_src', [\Avada::get_instance()->images, 'wp_get_attachment_image_fix_svg'], 10);
    }
}
