<?php

namespace R6Digital\KitchenSink\Performance;

class DisableGravityFormsDomParser extends Module
{
    public function is_available(): bool
    {
        return class_exists('GFForms');
    }

    public function get_name(): string
    {
        return 'Gravity Forms: Disable DOM Parser';
    }

    public function get_description(): string
    {
        return 'Prevent Gravity Forms from parsing the entire HTML output on every page load.';
    }

    public function get_unavailable_message(): string
    {
        return 'Gravity Forms is not installed.';
    }

    public function run(): void
    {
        remove_action('init', ['GFForms', 'init_buffer']);
    }
}
