<?php

namespace R6Digital\KitchenSink\Performance;

class WooCommerceDeferTransactionalEmails extends Module
{
    public function is_available(): bool
    {
        return class_exists('WooCommerce');
    }

    public function get_name(): string
    {
        return 'WooCommerce: Defer Transactional Emails';
    }

    public function get_description(): string
    {
        return 'Sends transactional emails (e.g. order emails) via a scheduled event instead of immediately. Improves checkout speed, but emails may be delayed by a few minutes. Recommend also configuring an external cron via WP-CLI.';
    }

    public function get_unavailable_message(): string
    {
        return 'WooCommerce is not installed.';
    }

    public function run(): void
    {
        add_filter('woocommerce_defer_transactional_emails', '__return_true');
    }
}
