<?php

namespace R6Digital\KitchenSink\Performance;

class WooCommerceDisableImageResizing extends Module
{
    public function is_available(): bool
    {
        return class_exists('WooCommerce');
    }

    public function get_name(): string
    {
        return 'WooCommerce: Disable on-the-fly image resizing';
    }

    public function get_description(): string
    {
        return 'Prevent WooCommerce from attempting to resize images on page load.';
    }

    public function get_unavailable_message(): string
    {
        return 'WooCommerce is not installed.';
    }

    public function run(): void
    {
        add_filter('woocommerce_resize_images', '__return_false');
    }
}
