<?php

namespace R6Digital\KitchenSink;

class SettingsPage
{
    public function __construct()
    {
        add_action('admin_menu', [$this, 'add_settings_menu']);
        add_filter(
            'plugin_action_links_' . plugin_basename(R6_KITCHEN_SINK_PATH . '/R6_Kitchen_Sink.php'),
            [$this, 'add_settings_link']
        );
    }

    public function add_settings_menu()
    {
        add_submenu_page(
            'options-general.php',
            R6_KITCHEN_SINK_NAME,
            R6_KITCHEN_SINK_NAME,
            'manage_options',
            R6_KITCHEN_SINK_ID,
            [$this, 'show']
        );
    }

    public function add_settings_link($links)
    {
        $link = '<a href="' . admin_url('options-general.php?page=' . R6_KITCHEN_SINK_ID) . '">Settings</a>';
        $links[] = $link;

        return $links;
    }

    public function show()
    {
        if ( ! empty($_POST)) {
            self::save_settings();
        }
        ?>
        <div class="wrap">
            <h2><?= R6_KITCHEN_SINK_NAME ?></h2>
        </div>

        <div class="card">
            <form method="post">
                <h3>Authentication</h3>

                <input type="hidden" name="section" value="authentication">

                <p>
                    <label><input type="checkbox" <?php
                        checked(get_option(R6_KITCHEN_SINK_ID . '_authentication_enabled', 1), 1) ?> value="1"
                                  name="authentication[enabled]"> Enable R6 Digital login</label>
                </p>

                <small><em>If disabled, existing users will still be able to log in but will need to use
                        username/password authentication.</em></small>

                <p>
                    <label><input type="checkbox" <?php
                        checked(get_option(R6_KITCHEN_SINK_ID . '_authentication_show_login_link', 1), 1) ?> value="1"
                                  name="authentication[show_login_link]"> Show button on login page</label>
                </p>

                <small><em>If disabled, users can use the R6 Digital login by going directly
                        to <?= Authentication::LOGIN_URL ?>.</em></small>


                <p>
                    <label><input type="checkbox" <?php
                        checked(get_option(R6_KITCHEN_SINK_ID . '_authentication_create_new_users', 1), 1) ?> value="1"
                                  name="authentication[create_new_users]"> Allow new users to be created</label>
                </p>

                <small><em>If disabled, only existing users can authenticate using R6 Digital login.</em></small>

                <p>
                    <button type="submit" class="button button-primary">Save</button>
                </p>

                <hr>

                <p>
                    <button type="button" class="button button-secondary" onclick="test_authentication();">Test
                        authentication
                    </button>
                </p>
            </form>
        </div>

        <script>
            function test_authentication() {
                window.open('<?= esc_js(
                    home_url(Authentication::LOGIN_URL)
                ) ?>' + '?test=true', '<?= esc_js(
                    R6_KITCHEN_SINK_NAME
                ) ?> Authentication Test', 'width=800, height=200');
            }
        </script>

        <div class="card">
            <form method="post">
                <h3>Branding</h3>

                <input type="hidden" name="section" value="branding">

                <p>
                    <label><input type="checkbox" <?php
                        checked(get_option(R6_KITCHEN_SINK_ID . '_branding_login', 1), 1) ?> value="1"
                                  name="branding[login]"> Show R6 Digital branding on login page</label>
                </p>

                <p>
                    <label><input type="checkbox" <?php
                        checked(get_option(R6_KITCHEN_SINK_ID . '_branding_admin', 1), 1) ?> value="1"
                                  name="branding[admin]"> Show R6 Digital branding in admin</label>
                </p>

                <p>
                    <button type="submit" class="button button-primary">Save</button>
                </p>
            </form>
        </div>

        <div class="card">
            <form method="post">
                <h3>URL Parameter Tracking</h3>

                <input type="hidden" name="section" value="url_parameter_tracking">

                <p>
                    <label>
                        <input
                                type="checkbox"
                            <?php
                            checked(get_option(R6_KITCHEN_SINK_ID . '_url_parameter_tracking_enabled', null), 1)
                            ?>
                                value="1" name="url_parameter_tracking[enabled]"
                        >
                        Enable URL Parameter Tracking
                    </label>
                </p>

                <p>
                    <label for="url_parameter_tracking[parameters]">
                        Tracked URL Parameters
                        <br>
                        <small><em>Each tag should be on a new line.</em></small>
                    </label>
                    <br>
                    <textarea
                            id="url_parameter_tracking[parameters]"
                            name="url_parameter_tracking[parameters]"
                            rows="5"
                            placeholder="utm_source&#10;utm_medium&#10;utm_campaign&#10;utm_term&#10;gclid"
                    ><?php
                        $parameter_string = get_option(
                            R6_KITCHEN_SINK_ID . '_url_parameter_tracking_parameters',
                            null
                        );
                        echo $parameter_string !== 0 ? $parameter_string : '';
                        ?></textarea>
                </p>

                <p>
                    <label
                        style="
                            <?= !class_exists('WPCF7_ContactForm') ? 'cursor: not-allowed;' : '' ?>
                        "
                    >
                        <input
                            type="checkbox"
                            <?php
                            checked(
                                get_option(R6_KITCHEN_SINK_ID . '_url_parameter_tracking_cf7_integration', null),
                                1
                            )
                            ?>
                            value="1" name="url_parameter_tracking[cf7_integration]"
                            <?= !class_exists('WPCF7_ContactForm') ? 'disabled' : '' ?>
                        >
                        <span
                            style="
                                <?= !class_exists('WPCF7_ContactForm') ? 'opacity: 50%;' : '' ?>
                            "
                        >
                            Append tracked URL parameters to all CF7 Forms submission emails.<br>
                            <span
                                style="
                                <?= !class_exists('WPCF7_ContactForm') ? 'color: orange;' : '' ?>
                                    "
                            >
                                <?=
                                !class_exists('WPCF7_ContactForm')
                                    ? 'Contact Form 7 plugin not detected'
                                    : '(This will only append captured parameters to the bottom of emails, will not persist in any other way)'
                                ?>
                            </span>
                        </span>
                    </label>
                </p>
                <br>
                <p>
                    <label for="url_parameter_tracking[form_selector]">
                        Form Field Input Selector
                        <br>
                        <small>
                            <em>
                                Use this field to specify a valid CSS selector for form fields to be filled.
                                <br><br>
                                If the URL Parameter term is required to be within the selector; specify its location
                                using the URL_PARAM identifier like the example below. Otherwise the term will be appended
                                to the end of the selector.
                            </em>
                        </small>
                    </label>
                <pre>form.plugin input[name="URL_PARAM"]</pre>
                <input
                        id="url_parameter_tracking[form_selector]"
                        name="url_parameter_tracking[form_selector]"
                        type="text"
                        style="width: 100%; font-family: monospace"
                        value="<?php
                        $parameter_string = get_option(
                            R6_KITCHEN_SINK_ID . '_url_parameter_tracking_form_selector',
                            null
                        );
                        echo $parameter_string !== 0 ? htmlspecialchars(stripslashes($parameter_string)) : '';
                        ?>"
                >
                <p>
                    <button type="submit" class="button button-primary">Save</button>
                </p>
            </form>
        </div>

        <div class="card">
            <form method="post">
                <h3>Performance</h3>

                <input type="hidden" name="section" value="performance">

                <?php foreach (Performance::instance()->get_modules() as $module) { ?>
                    <fieldset <?= disabled(!$module->is_available()) ?>>
                        <?php if (!$module->is_available()) { ?>
                            <span class="unavailable-message"><?= $module->get_unavailable_message() ?></span>
                        <?php } ?>

                        <p>
                            <label>
                                <input type="checkbox" name="performance[modules][]" value="<?= esc_attr(get_class($module)) ?>" <?php checked($module->is_enabled()) ?>>
                                <?= esc_html($module->get_name()) ?>
                            </label>
                        </p>

                        <?php if ($module_description = $module->get_description()) { ?>
                            <small><em><?= $module_description ?></em></small>
                        <?php } ?>
                    </fieldset>

                    <?php if (!$module->is_available() && $module->is_enabled()) { ?>
                        <input type="hidden" name="performance[modules][]" value="<?= esc_attr(get_class($module)) ?>">
                    <?php } ?>
                <?php } ?>

                <p>
                    <button type="submit" class="button button-primary">Save</button>
                </p>
            </form>
        </div>

        <style>
            fieldset:disabled > :not(.unavailable-message) {
                opacity: 0.5;
                pointer-events: none;
            }

            .unavailable-message {
                float: right;
                margin: 1em 0 0 2em;
                background-color: #e1e1e1;
                border-radius: 10em;
                padding: 0.1em 0.5em;
                border: 1px solid rgba(0, 0, 0, 0.2);
            }
        </style>
        <?php
    }

    public function save_settings()
    {
        switch ($_POST['section']) {
            case 'authentication':
                foreach (['enabled', 'show_login_link', 'create_new_users'] as $field) {
                    update_option(R6_KITCHEN_SINK_ID . '_authentication_' . $field, $_POST['authentication'][$field] ?? 0);
                }
                break;

            case 'branding':
                foreach (['login', 'admin'] as $field) {
                    update_option(R6_KITCHEN_SINK_ID . '_branding_' . $field, $_POST['branding'][$field] ?? 0);
                }
                break;

            case 'url_parameter_tracking':
                foreach (['enabled', 'parameters', 'cf7_integration', 'form_selector'] as $field) {
                    update_option(
                        R6_KITCHEN_SINK_ID . '_url_parameter_tracking_' . $field,
                        $_POST['url_parameter_tracking'][$field] ?? 0
                    );
                }
                break;

            case 'performance':
                Performance::instance()->set_enabled_modules(wp_unslash($_POST['performance']['modules'] ?? []));
                break;
        }
    }
}
