<?php

namespace R6Digital\KitchenSink;

use R6Digital\KitchenSink\WPCF7\FormTab;
use R6Digital\KitchenSink\WPCF7\Service;
use R6Digital\KitchenSink\WPCF7\SitelinkFormTab;
use R6Digital\KitchenSink\WPCF7\SitelinkService;

class WPCF7
{
    /**
     * @var class-string<Service>[]
     */
    protected $services = [
        SitelinkService::class,
    ];

    /**
     * @var class-string<FormTab>[]
     */
    protected $form_tabs = [
        SitelinkFormTab::class,
    ];

    public function __construct()
    {
        if (!class_exists('WPCF7')) {
            return;
        }

        add_action('wpcf7_init', [$this, 'register_services'], 20, 0);
        add_filter('wpcf7_pre_construct_contact_form_properties', [$this, 'register_form_tabs'], 10, 2);
        add_filter('wpcf7_mail_tag_replaced', [$this, 'mail_tags'], 10, 4);
    }

    public function register_services()
    {
        $integration = \WPCF7_Integration::get_instance();

        $integration->add_category('conversion_tracking', 'Conversion tracking');

        foreach ($this->services as $class) {
            $service = $class::get_instance();

            $integration->add_service($service::service_name, $service);
        }
    }

    public function register_form_tabs(array $properties, \WPCF7_ContactForm $form)
    {
        foreach ($this->form_tabs as $class) {
            $tab = $class::get_instance();

            if (!$tab->is_active()) {
                continue;
            }

            $name = $tab->get_name();
            $properties[$name] = [];

            add_filter("wpcf7_contact_form_property_{$name}", [$tab, 'setup'], 10, 2);
            add_action('wpcf7_save_contact_form', [$tab, 'save'], 10, 1);
            add_filter('wpcf7_editor_panels', [$tab, 'add_editor_panel'], 10, 1);
            add_action('wpcf7_mail_sent', [$tab, 'mail_sent'], 10, 1);
        }

        return $properties;
    }

    /**
     * @param $replaced
     * @param $submitted
     * @param $html
     * @param \WPCF7_MailTag|string $mail_tag
     * @return mixed|string
     */
    public function mail_tags($replaced, $submitted, $html, $mail_tag)
    {
        if (!$mail_tag) {
            return $replaced;
        }

        if ($mail_tag instanceof \WPCF7_MailTag) {
            $tag_name = $mail_tag->tag_name();
        }

        if (preg_match('/^_post_meta:(.+)/', $tag_name, $matches)) {
            $replaced = $this->mail_tag_post_meta($matches[1], $html, $mail_tag);
        }

        return $replaced;
    }

    protected function mail_tag_post_meta(string $meta_key, $html, \WPCF7_MailTag $mail_tag)
    {
        $replaced = '';

        $values = $mail_tag->values();
        $default = $values[0] ?? '';

        $instance = \WPCF7_Submission::get_instance();
        if (!$instance) {
            return $replaced;
        }
        $form_post_id = $instance->get_meta('container_post_id');

        if ($form_post_id) {
            $replaced = get_post_meta($form_post_id, $meta_key, true) ?: $default;

            if ($html) {
                $replaced = esc_html($replaced);
            }
        }

        return $replaced;
    }
}
