<?php

namespace R6Digital\KitchenSink\WPCF7;

abstract class FormTab
{
    abstract static function get_instance(): self;

    abstract function is_active(): bool;

    abstract function get_name(): string;

    abstract function get_title(): string;

    abstract protected function get_defaults(): array;

    abstract protected function get_submitted(): array;

    abstract protected function render(): void;

    function setup(array $properties, \WPCF7_ContactForm $form): array
    {
        return wp_parse_args($properties, $this->get_defaults());
    }

    function save(\WPCF7_ContactForm $form)
    {
        $form->set_properties([
            $this->get_name() => wp_parse_args(
                $this->get_submitted(),
                $this->get_defaults(),
            ),
        ]);
    }

    function add_editor_panel(array $panels): array
    {
        $panels[$this->get_name() . '-panel'] = [
            'title' => $this->get_title(),
            'callback' => [$this, 'render'],
        ];

        return $panels;
    }

    function mail_sent(\WPCF7_ContactForm $form)
    {
    }
}
