<?php

namespace AceIDE\Editor;

use WP_Error;
use AceIDE\Editor\Modules\Module;
use AceIDE\Editor\Modules\IDE;

class R6Styles extends IDE {

    private $menu_hook;

    function __construct() {

        $this->site_url = get_bloginfo('url');

		$actions = array (
			array('admin_menu', array( &$this, 'add_r6_styles_page') ),
			array('admin_head', array( &$this, 'add_r6_styles_icon') ),
			array( 'admin_init', array( &$this, 'init_hooks' ) ),
            array( 'network_admin_menu', array( &$this, 'add_my_menu_page' ) )
		);

		// hook for processing incoming image saves
		if ( isset( $_GET['aceide_save_image'] ) ) {
			// force local file method for testing
			$this->override_fs_method( 'direct' );

			$actions[] = array('admin_init', array( &$this, 'save_image') );
		}

		$this->add_actions($actions);
    }

    public function r6styles() {
        $this->__construct();
    }

    //===================================//
    // Add to Admin page
    //===================================//

    public function add_r6_styles_page() {
        global $wp_version;

		// We should not even display a menu item if we can't edit files
		if ( defined( 'DISALLOW_FILE_EDIT' ) && ! apply_filters( 'aceide_override_disallow_file_edit', ! DISALLOW_FILE_EDIT ) ) {
			return;
		}

		if ( version_compare( $wp_version, '3.8', '<' ) ) {
			$this->menu_hook = add_menu_page( 'R6 Styles', 'R6 Styles', 'edit_themes', "r6_styles", array( &$this, 'r6_menu_page') );
		} else {
			$this->menu_hook = add_menu_page( 'R6 Styles', 'R6 Styles', 'edit_themes', "r6_styles", array( &$this, 'r6_menu_page'), plugins_url( "R6Digital_White.png", __FILE__ ) );
		}
    } 

    public function add_r6_styles_icon() {
    ?><style type="text/css">
            #toplevel_page_r6_styles .wp-menu-image {
                background-image: url('<?php echo plugins_url( 'R6Digital_White.png', __FILE__ ); ?>');
                background-size: 75%;
                background-position: center;
                background-repeat: no-repeat;
            }
            #toplevel_page_r6_styles:hover .wp-menu-image,
            #toplevel_page_r6_styles.current .wp-menu-image {
                background-position: center !important;
            }
            #toplevel_page_r6_styles .wp-menu-image img {
                display: none;
            }
            #toplevel_page_r6_styles.current .wp-menu-name {
                padding-left: 45px;
            }
        </style>
    <?php
    }

    //===================================//
    // Enqueue Scripts and Styles
    //===================================//

    public function setup_hooks() {
        return array (
			array( 'admin_print_scripts-' . $this->menu_hook, array( &$this, 'add_admin_js' ) ),
            array( 'admin_print_styles-'  . $this->menu_hook, array( &$this, 'add_admin_styles' ) ),
            array( 'admin_print-styles-' . $this->menu_hook, array( &$this, 'add_admin_r6styles' ) ),
			array( 'wp_ajax_jqueryFileTree',        array( &$this, 'jqueryFileTree_get_list' ) ),

			array( 'wp_ajax_aceide_image_edit_key', array( &$this, 'image_edit_key' )  ),
			array( 'wp_ajax_aceide_startup_check',  array( &$this, 'startup_check' ) ),

			// add a warning when navigating away from AceIDE
			// it has to go after WordPress scripts otherwise WP clears the binding
			// This has been implemented in load-editor.js
			// add_action('admin_print_footer_scripts', array( &$this, 'add_admin_nav_warning' ), 99 );

			// Add body class to collapse the wp sidebar nav
			array( 'admin_body_class', array( &$this, 'hide_wp_sidebar_nav' ), 11),

			// hide the update nag
			array( 'admin_menu', array( &$this, 'hide_wp_update_nag' ) ),
		);
    }
    
    public function add_admin_r6styles() {
        $plugin_path = trailingslashit( plugin_dir_path(__FILE__) );
        $plugin_url  = trailingslashit( plugin_dir_url( $plugin_path ) );

		$acever = $this->ace_version;
		$idever = get_plugin_data( $plugin_path, false, false );
		$idever = $idever['Version'];

		// main R6 styles
		wp_register_style( 'r6styles_style', "{$plugin_url}assets/r6-admin-styles.css", array(), $idever );
		wp_enqueue_style( 'r6styles_style' );

	}


    //===================================//
    // Menu Page
    //===================================//

    public function r6_menu_page() {
        include('r6-styles-menu-page.php');
    }

    //===================================//
    // Callbacks
    //===================================//

}