<?php
// Do not check for a nonce, however check other permissions
self::check_perms(false);

$app_url = get_bloginfo('url'); // need to make this https if we are currently looking on the site using https (even though https for admin might not be forced it can still cause issues)
if (is_ssl()) {
    $app_url = str_replace("http:", "https:", $app_url);
}

$url    = trailingslashit(site_url());
$root   = apply_filters("aceide_filesystem_root", WP_CONTENT_DIR);
$root   = trailingslashit($root);
$root   = str_replace(ABSPATH, $url, $root);
$root   = untrailingslashit($root);

do_action('pre_output_aceide_menu_page');
do_action('pre_output_aceide_menu_page_scripts');
?>
<script>
    var aceide_app_path = "<?php echo plugin_dir_url(__FILE__); ?>";
    // dont think this is needed any more.. var aceide_file_root_url = "<?php echo $root ?>";
    var user_nonce_addition = '';

    function the_filetree() {
        jQuery('#aceide_file_browser').fileTree({
            script: ajaxurl
        }, function(parent, file) {

            if (jQuery(parent).hasClass("create_new")) { // create new file/folder
                // to create a new item we need to know the name of it so show input

                var item = eval('(' + file + ')');

                // hide all inputs just incase one is selected
                jQuery(".new_item_inputs").hide();
                // show the input form for this
                jQuery("div.new_" + item.type).show();
                jQuery("div.new_" + item.type + " input[name='new_" + item.type + "']").focus();
                jQuery("div.new_" + item.type + " input[name='new_" + item.type + "']").attr("rel", file);


            } else if (jQuery(".aceide_tab[rel='" + file + "']").length > 0) { // focus existing tab
                jQuery(".aceide_tab[sessionrel='" + jQuery(".aceide_tab[rel='" + file + "']").attr("sessionrel") + "']").click(); // focus the already open tab
            } else { // open file
                var image_pattern = new RegExp("\\.(jpg|gif|png|bmp)$");
                if (image_pattern.test(file)) {
                    // it's an image so open it for editing

                    // using modal+iframe
                    if ("lets not" == "use the modal for now") {

                        var NewDialog = jQuery('<div id="MenuDialog">\
                                <iframe src="http://www.sumopaint.com/app/?key=ebcdaezjeojbfgih&target=<?php echo get_bloginfo('url'); ?>?action=aceide_image_save&url=<?php echo $root; ?>' + file + '&title=Edit image&service=Save back to AceIDE" width="100%" height="600px"> </iframe>\
                                </div>');
                        NewDialog.dialog({
                            modal: true,
                            title: "title",
                            show: 'clip',
                            hide: 'clip',
                            width: '800',
                            height: '600'
                        });
                    } else { // open in new tab/window
                        var data = {
                            action: 'aceide_image_edit_key',
                            file: file,
                            _wpnonce: jQuery('#_wpnonce').val(),
                            _wp_http_referer: jQuery('#_wp_http_referer').val()
                        };
                        var image_data = '';
                        var image_title = encodeURIComponent(file.match(/(^|\/)([^\/]*$)/)[2]);
                        jQuery.ajaxSetup({
                            async: false
                        }); // we need to wait until we get the response before opening the window
                        jQuery.post(ajaxurl, data, function(response) {
                            // with the response (which is a nonce), build the json data to pass to the image editor. The edit key (nonce) is only valid to edit this image
                            image_data = file + '::' + response;
                        });
                        jQuery.ajaxSetup({
                            async: true
                        }); // enable async again

                        window.open('http://www.sumopaint.com/app/?key=ebcdaezjeojbfgih&url=<?php echo $root; ?>' + file + '&opt=' + image_data + '&title=' + image_title + '&service=Save back to AceIDE&target=<?php echo urlencode($app_url . "/wp-admin/admin.php?aceide_save_image=yes"); ?>');
                    }
                } else {
                    jQuery(parent).addClass('wait');

                    // check the status of the file in the database

                    jQuery.ajax({
                            type: "GET",
                            url: ajaxurl,
                            dataType: 'json',
                            data: {
                                action: 'file_status_get',
                                file: file,
                            }
                        })
                        .done(function(data) {
                            console.log("getFileStatus");
                            console.log(data);

                            // if the file's status exists in the database, then check to see if it is locked or not
                            // if the file's status doesn't exist, create the file's status and open it.
                            if (data) {
                                if (!data.locked || data.locked == 'false') {
                                    updateFileStatus(file);
                                    fillEditor(file, parent);

                                } else if (data.locked == 'true') {
                                    jQuery('.locked-modal-wrapper #modal-user').text(`${data.user} (User ID: ${data.user_id})`);
                                    var currTime = new Date();
                                    var fileTime = new Date(data.time);
                                    var difference = Date.parse(currTime) - Date.parse(fileTime);
                                    var minutes = Math.floor((difference / 1000 / 60) % 60);
                                    var hours = Math.floor(difference / 1000 / 60 / 60);

                                    jQuery('.locked-modal-wrapper #modal-activity').text(`${hours}hrs ${minutes} minutes`);
                                    jQuery('.locked-modal-wrapper').fadeIn();
                                    jQuery(parent).removeClass('wait');
                                    jQuery('.locked-modal-wrapper #modal-force-unlock')
                                        .show()
                                        .click(function (e) {
                                            updateFileStatus(file, false);
                                            fillEditor(file, parent);
                                            updateFileStatus(file, true);
                                        });
                                }
                            } else {
                                insertFileStatus(file);
                                fillEditor(file, parent);
                            }

                            // if the window is closed, we want to update the file status to unlocked
                            var onWindowCloseEvent = false;
                            window.onbeforeunload = (function() {
                                if (!onWindowCloseEvent) {
                                    onWindowCloseEvent = true;
                                    jQuery('.aceide_tab').each(function() {
                                        console.log(jQuery(this));
                                        updateFileStatus(jQuery(this).attr('rel'), false);
                                    });
                                }
                                // Chrome requires a return from the unload function. No one actually sees this
                                return "";
                            });

                        })
                        .fail(function(jqXHR, textStatus, errorThrown) {
                            console.log(`${jqXHR} :: ${textStatus} :: ${errorThrown}`);
                        });

                    function fillEditor(file, parent) {
                        aceide_set_file_contents(file, function() {
                            // once file loaded remove the wait class/indicator
                            jQuery(parent).removeClass('wait');
                            jQuery('.locked-modal-wrapper').fadeOut();
                            jQuery('.locked-modal-wrapper #modal-force-unlock').hide();
                        });

                        var fileName = file.slice(file.lastIndexOf('/') + 1);

                        jQuery('.jqueryFileTree .file a[rel="' + file + '"]')
                            .html(fileName + " <span>(You have this open)</span>")
                            .parent().addClass('user-open');
                        if (jQuery('.jqueryFileTree .file a[rel="' + file + '"]').parent().hasClass('locked')) {
                            jQuery('.jqueryFileTree .file a[rel="' + file + '"]').parent().removeClass('locked');
                        }
                        jQuery('#filename').val(file);
                    }

                    function insertFileStatus(file) {
                        jQuery.ajax({
                            type: "POST",
                            url: ajaxurl,
                            dataType: 'json',
                            data: {
                                action: 'file_status_insert',
                                file: file,
                                locked: true
                            },
                            success: function(data) {
                                console.log("insertFileStatus");
                                console.log(data);
                            },
                            error: function(jqXHR, textStatus, errorThrown) {
                                console.log(`${jqXHR} :: ${textStatus} :: ${errorThrown}`);
                            },
                        });
                    }

                    function updateFileStatus(file, locked = true) {

                        jQuery.ajax({
                            type: "POST",
                            url: ajaxurl,
                            dataType: 'json',
                            data: {
                                action: 'file_status_update',
                                file: file,
                                locked: locked
                            },
                            success: function(data) {
                                console.log("updateFileStatus");
                                console.log(data);
                            },
                            error: function(jqXHR, textStatus, errorThrown) {
                                console.log(`${jqXHR} :: ${textStatus} :: ${errorThrown}`);
                            },
                        });
                    }
                }
            }

        });
    }

    jQuery(document).ready(function($) {
        //				$("#fancyeditordiv").css("height", ($('body').height()-120) + 'px' );

        $(document).trigger('aceide:prefiletree');

        // Handler for .ready() called.
        the_filetree();

        $(document).trigger('aceide:postfiletree');

        // inialise the color assist
        $("#aceide_color_assist img").ImageColorPicker({
            afterColorSelected: function(event, color) {
                jQuery("#aceide_color_assist_input").val(color);
            }
        });
        $("#aceide_color_assist").hide(); // hide it until it's needed

        $("#aceide_color_assist_send").click(function(e) {
            e.preventDefault();
            editor.insert(jQuery("#aceide_color_assist_input").val().replace('#', ''));

            $("#aceide_color_assist").hide(); // hide it until it's needed again
        });

        $(".close_color_picker a").click(function(e) {
            e.preventDefault();
            $("#aceide_color_assist").hide(); // hide it until it's needed again
        });

        $("#aceide_toolbar_buttons").on('click', "a.restore", function(e) {
            e.preventDefault();
            var file_path = jQuery(".aceide_tab.active", "#aceide_toolbar").data("backup");

            jQuery("#aceide_message").hide(); // might be shortly after a save so a message may be showing, which we don't need
            jQuery("#aceide_message").html('<span><strong><?php _e('File available for restore'); ?></strong><p> ' + file_path + '</p><a class="button red restore now" href="' + aceide_app_path + file_path + '"><?php _e('Restore this file now &#10012;'); ?></a><a class="button restore cancel" href="#"><?php _e('Cancel &#10007;'); ?></a><br /><em class="note"><strong>note: </strong><?php _e('You can browse all file backups if you navigate to the backups folder (plugins/AceIDE/backups/..) using the filetree.'); ?></em></span>');
            jQuery("#aceide_message").show();
        });
        $("#aceide_toolbar_buttons").on('click', "a.restore.now", function(e) {
            e.preventDefault();

            var data = {
                restorewpnonce: user_nonce_addition + jQuery('#_wpnonce').val()
            };
            jQuery.post(aceide_app_path + jQuery(".aceide_tab.active", "#aceide_toolbar").data("backup"), data, function(response) {

                if (response == -1) {
                    alert("<?php _e('Problem restoring file.'); ?>");
                } else {
                    alert(response);
                    jQuery("#aceide_message").hide();
                }

            });

        });
        $("#aceide_toolbar_buttons").on('click', "a.cancel", function(e) {
            e.preventDefault();

            jQuery("#aceide_message").hide(); // might be shortly after a save so a message may be showing, which we don't need
        });


        // Locked Modal
        $('.locked-modal-wrapper .close-btn').click(function(e) {
            $(this).closest('.locked-modal-wrapper').fadeOut();
        });

        $('#r6_search_dialog .close-btn').click(function(e) {
            $(this).closest('#r6_search_dialog').fadeOut();
        });

    });
</script>
<?php
do_action('post_output_aceide_menu_page_scripts');
do_action('pre_output_aceide_menu_page_html');
?>
<div id="poststuff" class="metabox-holder has-right-sidebar">
    <div id="side-info-column" class="inner-sidebar">
        <img src="<?php echo plugins_url('R6Logo.png', __FILE__); ?>" id="aceidelogo" />
        <div id="aceide_info">
            <div id="aceide_info_content"></div>
        </div>
        <br style="clear:both;" />

        <div id="submitdiv" class="postbox ">
            <h3 class="hndle"><span>Files</span></h3>
            <div class="inside">
                <ul id="drag_coverup" class="jqueryFileTree" style="position: absolute; background-color: white; z-index: -1;"></ul>
                <div class="submitbox" id="submitpost">
                    <div id="minor-publishing"></div>
                    <div id="major-publishing-actions">
                        <div id="aceide_file_browser"></div>
                        <br style="clear:both;" />
                        <div class="new_file new_item_inputs">
                            <label for="new_folder"><?php _e('File name'); ?></label>
                            <input class="has_data" name="new_file" type="text" rel="" value="" placeholder="<?php esc_attr_e('Filename'); ?>" />
                            <a href="#" id="aceide_create_new_file" class="button-primary"><?php _e('CREATE'); ?></a>
                        </div>
                        <div class="new_directory new_item_inputs">
                            <label for="new_directory"><?php _e('Directory name'); ?></label><input class="has_data" name="new_directory" type="text" rel="" value="" placeholder="<?php esc_attr_e('Folder'); ?>" />
                            <a href="#" id="aceide_create_new_directory" class="button-primary"><?php esc_html_e('CREATE'); ?></a>
                        </div>
                        <div class="clear"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="post-body">
        <div id="aceide_container">
            <div id="aceide_toolbar" class="quicktags-toolbar">
                <div id="aceide_toolbar_tabs"> </div>
                <div id="dialog_window_minimized_container"></div>
            </div>

            <div id="aceide_toolbar_buttons">
                <div id="aceide_message"></div>
                <a class="button restore" style="display:none;" title="<?php esc_attr_e('Restore the active tab'); ?>" href="#"><?php _e('Restore &#10012;'); ?></a>
            </div>
            <div id='fancyeditordiv'></div>
            <form id="aceide_save_container" action="" method="get">
                <div id="aceide_footer_message"></div>
                <div id="aceide_footer_message_last_saved"></div>
                <div id="aceide_footer_message_unsaved"></div>

                <a href="#" id="aceide_save" alt="<?php esc_attr_e('Keyboard shortcut to save [Ctrl/Cmd + S]'); ?>" title="<?php esc_attr_e('Keyboard shortcut to save [Ctrl/Cmd + S]'); ?>" class="button-primary"><?php esc_html_e('SAVE FILE'); ?></a>
                <?php if (defined('WP_DEBUG') && WP_DEBUG) : ?>
                    <a href="#" id="aceide_git" alt="Open the Git overlay" title="Open the Git overlay" class="button-secondary"><?php esc_html_e('Git'); ?></a>
                <?php endif; ?>
                <input type="hidden" id="filename" name="filename" value="" />
                <?php
                if (function_exists('wp_nonce_field')) {
                    wp_nonce_field('plugin-name-action_aceidenonce');
                }
                ?>
            </form>
        </div>
        <div class="locked-modal-wrapper">
            <div class="modal-header">
                <div class="close-btn"><i class="far fa-times-circle"></i></div>
                <h3 class="modal-heading">This file is locked by another user.</h3>
            </div>
            <div class="modal-body">
                <div class="modal-content">
                    <p>User: <span id="modal-user"></span></p>
                    <p>Time since last activity: <span id="modal-activity"></span></p>
                    <div class="force-unlock-wrapper">
                        <div id="modal-force-unlock"><i class="fas fa-lock"></i><span>FORCE UNLOCK FILE</span></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="editor_find_dialog" title="<?php esc_attr_e('Find...'); ?>" style="padding: 0px; display: none;">
    <?php if (false) : ?>
        <ul>
            <li><a href="#find-inline"><?php esc_html_e('Text'); ?></a></li>
            <li><a href="#find-func"><?php esc_html_e('Function'); ?></a></li>
        </ul>
    <?php endif; ?>
    <form id="find-inline" style="position: relative; padding: 4px; margin: 0px; height: 100%; overflow: hidden; width: 400px;">
        <label class="left"> <?php esc_html_e('Find'); ?><input type="search" name="find" /></label>
        <label class="left"> <?php esc_html_e('Replace'); ?><input type="search" name="replacement" /></label>
        <div class="clear" style="height: 33px;"></div>

        <label><input type="checkbox" name="wrap" checked="checked" /> <?php esc_html_e('Wrap Around'); ?></label>
        <label><input type="checkbox" name="case" /> <?php esc_html_e('Case Sensitive'); ?></label>
        <label><input type="checkbox" name="whole" /> <?php esc_html_e('Match Whole Word'); ?></label>
        <label><input type="checkbox" name="regexp" /> <?php esc_html_e('Regular Expression'); ?></label>

        <div class="search_direction">
            <?php esc_html_e('Direction:'); ?>
            <label><input type="radio" name="direction" value="0" /> <?php esc_html_e('Up'); ?></label>
            <label><input type="radio" name="direction" value="1" checked="checked" /> <?php esc_html_e('Down'); ?></label>
        </div>
        <div class="right">
            <input type="submit" name="submit" value="<?php esc_attr_e('Find'); ?>" class="action_button" />
            <input type="button" name="replace" value="<?php esc_attr_e('Replace'); ?>" class="action_button" />
            <input type="button" name="replace_all" value="<?php esc_attr_e('Replace All'); ?>" class="action_button" />
            <input type="button" name="cancel" value="<?php esc_attr_e('Cancel'); ?>" class="action_button" />
        </div>
    </form>
    <?php if (false) : ?>
        <form id="find-func">
            <label class="left"> <?php esc_html_e('Function'); ?><input type="search" name="find" /></label>
            <div class="right">
                <input type="submit" name="submit" value="<?php esc_attr_e('Find Function'); ?>" class="action_button" />
            </div>
        </form>
    <?php endif; ?>
</div>
<div id="editor_goto_dialog" title="<?php esc_attr_e('Go to...'); ?>" style="padding: 0px; display: none;">
    <form>
        <p><input type="text" id="line" name="line" value="0" /></p>
        <p>
            <input type="submit" name="submit" value="Go To" />
            <input type="button" name="cancel" value="Cancel" />
        </p>
    </form>
</div>
<div id="editor_settings_dialog" style="padding: 10px 10px 5px; display: none;">
    <div class="left">
        <label><?php _e('Theme:'); ?> <input type="text" id="editor_theme_setting" class="ipt-sel"></label>
        <label><?php _e('Folding:'); ?> <select id="editor_folding_setting" class="ipt-sel">
                <option value="manual"><?php _e('Manual'); ?></option>
                <option value="markbegin" selected="selected"><?php _e('Beginning'); ?></option>
                <option value="markbeginend"><?php _e('Beginning And End'); ?></option>
            </select></label>
        <label><?php _e('Font Size:'); ?> <input type="number" id="editor_font_size_setting" class="number"></label>
        <label><?php _e('Wrap Limit:'); ?> <input type="number" id="editor_wrap_limit_setting" class="number"></label>
        <label><?php _e('Wrap Long Text:'); ?> <input type="checkbox" id="editor_wrap_setting"></label>
        <label><?php _e('Fade Folders:'); ?> <input type="checkbox" id="editor_fade_fold_setting"></label>
    </div>
    <div class="right">
        <label><?php _e('Highlight Current Line:'); ?> <input type="checkbox" id="editor_highlight_line_setting"></label>
        <label><?php _e('Show Invisible Characters:'); ?> <input type="checkbox" id="editor_show_invisibles"></label>
        <label><?php _e('Show Indent Guidelines:'); ?> <input type="checkbox" id="editor_display_indent_guides_setting"></label>
        <label><?php _e('Animate Scrollbar:'); ?> <input type="checkbox" id="editor_animate_scroll_setting"></label>
        <label><?php _e('Show Gutter:'); ?> <input type="checkbox" id="editor_show_gutter_setting"></label>
        <label><?php _e('Use Tabs:'); ?> <input type="checkbox" id="editor_use_tabs_setting"></label>
        <label><?php _e('Highlight Same Words:'); ?> <input type="checkbox" id="editor_word_highlight"></label>
        <label><?php _e('Show Behaviours:'); ?> <input type="checkbox" id="editor_behaviours_setting"></label>
    </div>
</div>
<div id="r6_search_dialog" style="display: none">
    <div class="close-btn"><i class="far fa-times-circle"></i></div>
    <div class="r6_search_box">
        <p><input type="text" id="search-query" name="search-query" /></p>
        <p id="submit-search">Find</p>
        <div class="r6-loader"></div>
    </div>
    <div class="r6_search_results"></div>
</div>
<?php
do_action('post_output_aceide_menu_page_html');
?>
