<?php

/**
 *Plugin Name: R6 Styles
 *Plugin URI: https://r6digital.com.au/
 *Description: A Wordpress code editor primarily for SCSS with added functionality of file restrictions and notifications
 *Version: 1.3.2
 *Author: R6 Digital
 *Author URI: https://r6digital.com.au/
 **/

const R6_STYLES_VERSION = '1.3.2';

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}


//==================================//
//Setting up global variables
//==================================//

if (!defined('R6_STYLES_DIR')) {
    define('R6_STYLES_DIR', get_stylesheet_directory());
}

if (!defined('R6_STYLES_PLUGIN_NAME')) {
    define('R6_STYLES_PLUGIN_NAME', trim(dirname(plugin_basename(__FILE__)), '/'));
}

if (!defined('R6_STYLES_PLUGIN_DIR')) {
    define('R6_STYLES_PLUGIN_DIR', WP_PLUGIN_DIR . '/' . R6_STYLES_PLUGIN_NAME);
}

//==================================//
//Setting up update repository
//==================================//
require __DIR__ . '/plugin-update-checker/plugin-update-checker.php';
$MyUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
    'https://internal.cfservers.com/wp-plugins/?action=get_metadata&slug=' . R6_STYLES_PLUGIN_NAME, //Metadata URL.
    __FILE__, //Full path to the main plugin file.
    R6_STYLES_PLUGIN_NAME //Plugin slug. Usually it's the same as the name of the directory.
);

//===================================//
// Set Dependencies
//  - AceIDE
//  - Simple History
//===================================//

require_once __DIR__ . '/editor/vendor/autoload.php';

include_once R6_STYLES_PLUGIN_DIR . '/editor/src/modules/Module.php';
include_once R6_STYLES_PLUGIN_DIR . '/editor/src/modules/FileOps.php';
include_once R6_STYLES_PLUGIN_DIR . '/editor/src/IDE.php';
include_once R6_STYLES_PLUGIN_DIR . '/simplehistory/index.php';

include_once 'db_setup.php';
register_activation_hook(__FILE__, ['R6_Styles_Database', 'setup_database']);

use AceIDE\Editor\Modules\FileOps;
use AceIDE\Editor\IDE;

SimpleHistory::get_instance();


//===================================//
//  Simple History settings
//===================================//

// So log can't be deleted easily
add_filter('simple_history/user_can_clear_log', function ($user_can_clear_log) {
    $user_can_clear_log = false;
    return $user_can_clear_log;
});

// Only loading a few loggers for what we need
add_filter('simple_history/logger/load_logger', function ($load_logger, $logger_basename) {
    $load_logger = false;
    $do_log_us = array('FileEditsLogger', 'SimplePostLogger', 'SimplePluginLogger', 'SimpleLogger');
    if (in_array($logger_basename, $do_log_us)) {
        $load_logger = true;
    }
    return $load_logger;
}, 10, 2);

//===================================//
//  Login & Branding
//===================================//
$plugin_path = trailingslashit(dirname(dirname(__FILE__))) . 'r6-styles';
$plugin_url  = trailingslashit(plugin_dir_url($plugin_path));

function add_login_sources()
{
    global $plugin_url;

    $show_custom_login = apply_filters('r6_styles_show_custom_login', true);

    if ($show_custom_login) {
        wp_enqueue_style('custom_login', "{$plugin_url}r6-styles/assets/custom-login.css"); // CSS for the login page
    }
}
add_action('login_enqueue_scripts', 'add_login_sources');

function login_logo_url()
{
    return 'https://r6digital.com.au';
}
add_filter('login_headerurl', 'login_logo_url');

// Custom frontend sources
function frontend_sources()
{
    global $plugin_url;

    $show_branding = apply_filters('r6_styles_admin_branding', true);

    if (is_admin_bar_showing() && $show_branding) {
        wp_register_style('r6_admin_menus_style', "{$plugin_url}r6-styles/assets/custom-admin-bar.css"); // Admin CSS
        wp_enqueue_style('r6_admin_menus_style');
        wp_enqueue_script('admin-bar-js', "{$plugin_url}r6-styles/includes/js/admin-bar.js", array('jquery')); // JS for the admin bar
    }
}
add_action('wp_head', 'frontend_sources');

// Custom backend sources
// function backend_sources() {
//     global $plugin_url;
//     if ( is_admin_bar_showing() ) {
//         wp_enqueue_style('custom_admin_bar', "{$plugin_url}r6-styles/assets/custom-admin-bar.css"); // CSS for the admin bar
//         wp_enqueue_script('admin-bar-js', "{$plugin_url}r6-styles/includes/js/admin-bar.js", array( 'jquery' )); // JS for the admin bar
//     }
// }
// add_action( 'admin_head', 'backend_sources' );

function apply_admin_sources()
{
    global $plugin_url;

    $show_branding = apply_filters('r6_styles_admin_branding', true);

    if ($show_branding) {
        wp_register_style('r6_admin_menus_style', "{$plugin_url}r6-styles/assets/custom-admin-bar.css"); // Admin CSS
        wp_enqueue_style('r6_admin_menus_style');
        wp_enqueue_script('admin-bar-js', "{$plugin_url}r6-styles/includes/js/admin-bar.js", array('jquery')); // JS for the admin bar
    }
}
add_action('admin_enqueue_scripts', 'apply_admin_sources');



$r6fileops = new AceIDE\Editor\Modules\FileOps;

if (!class_exists('R6Styles')) :
    class R6Styles extends IDE
    {

        private $menu_hook;

        private $modules = array();

        function __construct()
        {

            $this->site_url = get_bloginfo('url');

            $actions = array(
                array('admin_menu', array( &$this, 'add_r6_styles_page')),
                array('admin_head', array( &$this, 'add_r6_styles_icon')),
                array('admin_init', array( &$this, 'init_hooks' )),
                array('network_admin_menu', array(&$this, 'add_r6_styles_page'))
            );

            // hook for processing incoming image saves
            if (isset($_GET['aceide_save_image'])) {
                // force local file method for testing
                $this->override_fs_method('direct');

                $actions[] = array('admin_init', array(&$this, 'save_image'));
            }

            $this->add_actions($actions);
        }

        public function r6styles()
        {
            $this->__construct();
        }

        //===================================//
        // Add to Admin page
        //===================================//

        public function add_r6_styles_page()
        {
            global $wp_version;

            // We should not even display a menu item if we can't edit files
            if (defined('DISALLOW_FILE_EDIT') && !apply_filters('aceide_override_disallow_file_edit', !DISALLOW_FILE_EDIT)) {
                return;
            }

            if (version_compare($wp_version, '3.8', '<')) {
                $this->menu_hook = add_menu_page('R6 Styles', 'R6 Styles', 'edit_themes', "r6_styles", array(&$this, 'r6_menu_page'));
            } else {
                $this->menu_hook = add_menu_page('R6 Styles', 'R6 Styles', 'edit_themes', "r6_styles", array(&$this, 'r6_menu_page'), plugins_url("R6Digital_White.png", __FILE__));
            }
        }

        public function add_r6_styles_icon()
        {
?><style type="text/css">
                #toplevel_page_r6_styles .wp-menu-image {
                    background-image: url('<?php echo plugins_url('R6Digital_White.png', __FILE__); ?>');
                    background-size: 75%;
                    background-position: center;
                    background-repeat: no-repeat;
                }

                #toplevel_page_r6_styles:hover .wp-menu-image,
                #toplevel_page_r6_styles.current .wp-menu-image {
                    background-position: center !important;
                }

                #toplevel_page_r6_styles .wp-menu-image img {
                    display: none;
                }

                #toplevel_page_r6_styles.current .wp-menu-name {
                    padding-left: 45px;
                }
            </style>
        <?php
        }

        //===================================//
        // Enqueue Scripts and Styles
        //===================================//

        public function setup_hooks()
        {
            return array(
                array('admin_print_scripts-' . $this->menu_hook, array(&$this, 'add_admin_js')),
                array('admin_print_styles-'  . $this->menu_hook, array(&$this, 'add_admin_styles')),
                array('admin_print-styles-' . $this->menu_hook, array(&$this, 'add_admin_r6styles')),
                array('wp_ajax_jqueryFileTree',        array(&$this, 'jqueryFileTree_get_list')),

                array('wp_ajax_aceide_image_edit_key', array(&$this, 'image_edit_key')),
                array('wp_ajax_aceide_startup_check',  array(&$this, 'startup_check')),

                // add a warning when navigating away from AceIDE
                // it has to go after WordPress scripts otherwise WP clears the binding
                // This has been implemented in load-editor.js
                // add_action('admin_print_footer_scripts', array( &$this, 'add_admin_nav_warning' ), 99 );

                // Add body class to collapse the wp sidebar nav
                array('admin_body_class', array(&$this, 'hide_wp_sidebar_nav'), 11),

                // hide the update nag
                array('admin_menu', array(&$this, 'hide_wp_update_nag')),

                // action for searching file contents
                array('wp_ajax_r6_search_action', array(&$this, 'r6_search_action')),
                array('wp_ajax_no_priv_r6_search_action', array(&$this, 'r6_search_action')),
            );
        }

        public function add_admin_styles()
        {
            $plugin_path = trailingslashit(dirname(dirname(__FILE__))) . 'r6-styles';
            $plugin_url  = trailingslashit(plugin_dir_url($plugin_path));

            error_log($plugin_path);
            error_log($plugin_url);

            $acever = $this->ace_version;
            $idever = get_plugin_data($plugin_path, false, false);
            $idever = $idever['Version'];

            // main AceIDE styles
            wp_register_style('aceide_style', "{$plugin_url}r6-styles/editor/src/aceide.css", array(), $idever);
            wp_enqueue_style('aceide_style');
            // filetree styles
            wp_register_style('aceide_filetree_style', "{$plugin_url}r6-styles/editor/src/css/jqueryFileTree.css", array('aceide_style'), $idever);
            wp_enqueue_style('aceide_filetree_style');
            // autocomplete dropdown styles
            wp_register_style('aceide_dd_style', "{$plugin_url}r6-styles/editor/src/dd.css", array('aceide_style'), $idever);
            wp_enqueue_style('aceide_dd_style');

            // jquery ui styles
            wp_register_style('aceide_jqueryui_style', "{$plugin_url}r6-styles/editor/src/css/flick/jquery-ui-1.8.20.custom.css", array('aceide_style'), $idever);
            wp_enqueue_style('aceide_jqueryui_style');

            // main R6 styles
            wp_register_style('r6styles_style', "{$plugin_url}r6-styles/assets/r6-admin-styles.css", array('aceide_style'), $idever);
            wp_enqueue_style('r6styles_style');

            wp_register_style('fontawesome', "https://use.fontawesome.com/releases/v5.6.1/css/all.css");
            wp_enqueue_style('fontawesome');
        }

        //===================================//
        // Menu Page
        //===================================//

        public function r6_menu_page()
        {
            include('r6-styles-menu-page.php');
        }

        //===================================//
        // Callbacks
        //===================================//

        public function r6_search_action()
        {

            // Searches through the file given and tries to find the search term given.
            // returns a json object containing either the line number if found, or false if not

            // Taken from a sample given in
            // https://stackoverflow.com/questions/19760564/php-find-a-string-in-file-then-show-its-line-number

            $search = $_POST['term'];
            $temp_file = R6_STYLES_PLUGIN_DIR . '/../..' . $_POST['tempFile'];

            $file_content = file_get_contents($temp_file);
            $content_before_string = stristr($file_content, $search, true);

            if ($content_before_string !== false) {
                $line = count(explode(PHP_EOL, $content_before_string));
                $res = array('line' => $line, 'file' => $_POST['tempFile']);
            } else {
                $res = array('line' => false, 'file' => $_POST['tempFile']);
            }

            echo json_encode($res);
            wp_die();
        }
    }

    $r6styles = new r6styles();
    $r6styles->extend($r6fileops);

endif; // $r6styles exists

?>
