# R6 Kitchen Sink

![A kitchen sink](assets/img/sink.jpg)

The Kitchen Sink is a WordPress plugin that contains a collection of useful functionality for websites developed by R6 Digital.

## Requirements

A minimum of PHP 7.2 is required. We have very few sites that are below this version.

## Installation

This plugin is already installed by default on our cPanel WordPress sites.

However, if you are using Composer to manage plugins, add this repo to your composer.json file, then require the plugin:
```shell
composer config repo.r6-kitchen-sink '{"type":"github","url":"git@github.com:r6digital/r6-kitchen-sink.git","only":["r6digital/r6-kitchen-sink"]}'
```

```
composer require r6digital/r6-kitchen-sink
```

## Modules

### Authentication

The authentication module allows R6 employees to log into WordPress with their Google account. On sites with a standard
WordPress login, a button or link will appear labelled "R6 Digital Login", which can be used to log in with full
administrator access (including super-admin when multisite is in use).

If the site has a custom login page and the button/link doesn't appear, you can go directly to `/r6-login` instead.

### Branding

The branding module adds R6 Digital branding to both the login screen and the admin area. Branding can be fully or
partially disabled in settings.

### Contact Form 7

The Contact Form 7 plugin adds common extra features to contact forms.

* A mail tag `[_post_meta]` for pulling meta fields (such as ACF) from the post the form was embedded on.  
  Usage:
  * Pass the meta key after a colon:  
    `[_post_meta:meta_key]`  
    Examples:
    ```
    [_post_meta:location_postcode]
    [_post_meta:contact_email]
    ```
  * Include a quoted attribute to specify a default value if the meta value is empty:  
    `[_post_meta:meta_key "default_value"]`  
    Examples:
    ```
    [_post_meta:location_postcode "4000"]
    [_post_meta:contact_email "noreply@example.com"]
    ```
    > [!IMPORTANT]
    > The default value must be quoted
* An integration for our [Sitelink Lead to Lease API](https://r6digital.atlassian.net/wiki/spaces/devprojects/pages/328630273/Lead+to+Lease+API)
  * Enable the integration by providing an API key and optionally a default location code
  * A new Sitelink tab will be available on each contact form where the field mappings can be configured.

### Compatibility

The compatibility module ensures that conflicts don't occur when used with other common R6 plugins.

* *WordPress Social Login* - only the login button from WordPress Social Login will appear. You can still
  go to `/r6-login` to use the login from Kitchen Sink.
* *R6 Styles (1.3.1 or earlier)* - Kitchen Sink will not attempt to show its own branding.

### Settings Page

This isn't really a separate module, but it provides a way to update the settings for Kitchen Sink. The settings link
is available both in the menu (under _Settings_) and on the plugins list.

## Development

Each aspect of the plugin should be clearly separated into its own module (this is just a fancy name for a class at this
point). There may be minor cases of crossover (for example, the branding module will add some extra styling for
authentication module) but each module should be able to be used independently.

Here are some other rules to follow:
* PSR-12 is to be used for code style.
* PSR-4 is to be used for autoloading.
* Minimise dependencies as much as possible. We want to keep the plugin light.
* Be consistent when it comes to class names, options, and IDs.
  * Constants have been provided in the root plugin file `R6_Kitchen_Sink.php` for this purpose.
  * In general, option identifiers should take the following form: `R6_KITCHEN_SINK_ID . '_MODULENAME_OPTIONNAME'`
  * Classes in the `R6Digital\KitchenSink` namespace will be autoloaded from the `src/` directory.
* Modules must have the ability to be disabled in settings. In some cases, you may also want to add the ability to
  disable or configure certain aspects of your module. Don't go overboard though, and only include configuration for
  aspects of the module that are actually likely to be changed. You can always add more later.
* Don't break backwards compatibility. It should always be safe to update Kitchen Sink automatically.

## Deployment

This plugin is hosted on the [R6 WordPress Repository](https://r6digital.atlassian.net/wiki/spaces/devteam/pages/310214658/Internal+WordPress+plugin+update+system). To deploy an update, follow these
steps:

1. Increment the version number in `R6_Kitchen_Sink.php`. It's in two places: the comment at the top of the file and
   in the constant `R6_KITCHEN_SINK_VERSION`.
2. Commit that change and tag it in Git: `git tag x.x.x`
3. Wait for the [GitHub action](https://github.com/r6digital/r6-kitchen-sink/actions/workflows/release.yml) to build a new release zip.
4. Upload the new zip to the R6 WordPress Repository.

## Authors

* Sam Horn
* Seamus Giess
* Lachlan Arthur
