<?php

namespace R6Digital\KitchenSink;

class Performance
{
    /**
     * @var class-string<Performance\Module>[]
     */
    const modules = [
        Performance\DisableAvadaSvg::class,
        Performance\DisableGravityFormsDomParser::class,
        Performance\WooCommerceDisableImageResizing::class,
        Performance\WooCommerceDeferTransactionalEmails::class,
    ];

    /**
     * @var class-string<Performance\Module>[]
     */
    protected $enabled_modules = [];

    static self $instance;

    protected function __construct()
    {
        $this->enabled_modules = array_intersect(
            self::modules,
            get_option(R6_KITCHEN_SINK_ID . '_performance_modules', []),
        );
    }

    public static function instance()
    {
        if (!isset(self::$instance)) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function init()
    {
        foreach ($this->get_modules() as $module) {
            if ($module->is_available() && $module->is_enabled()) {
                $module->run();
            }
        }
    }

    /**
     * @return Performance\Module[]
     */
    public function get_modules()
    {
        $modules = [];

        foreach (self::modules as $class) {
            $modules[] = new $class;
        }

        return $modules;
    }

    /**
     * @param class-string<Performance\Module> $class
     *
     * @return bool
     */
    public function is_module_enabled(string $class): bool
    {
        return in_array($class, $this->enabled_modules, true);
    }

    /**
     * @return class-string<Performance\Module>[]
     */
    public function get_enabled_modules(): array
    {
        return $this->enabled_modules;
    }

    /**
     * @param class-string<Performance\Module>[] $classes
     */
    public function set_enabled_modules(array $classes)
    {
        $this->enabled_modules = array_intersect(self::modules, $classes);

        update_option(R6_KITCHEN_SINK_ID . '_performance_modules', $classes);
    }
}
