<?php
// Runs when the plugin is first activated, and works to set up the database table we wish to use
class R6_Styles_Database {
    public static function setup_database() {

        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();
        $table_name = $wpdb->prefix . 'r6_file_locking';

        $sql = "CREATE TABLE $table_name (
	    	filename char(100) NOT NULL,
		    time datetime NOT NULL,
		    locked char(10) NOT NULL,
            user varchar(100) NOT NULL,
            user_id int(11) NOT NULL,
		
		    PRIMARY KEY  (filename)
	    ) $charset_collate;";

        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $sql );
    }

    // This function updates the file status in the database.
    public static function file_status_insert() {

        // Get the database object, and include the wordpress prefix in the table name
        global $wpdb;
        $table_name = $wpdb->prefix . "r6_file_locking";
        $user = wp_get_current_user();
        $data = $_POST;

        $updated_status = array(
            'filename' => $data['file'],
            'time' => date('Y-m-d H:i:s', strtotime("+10 hours")),
            'locked' => $data['locked'],
            'user' => $user->user_login,
            'user_id' => $user->ID
        );

        // insert the data into the database
        echo $wpdb->replace($table_name, $updated_status);

        if ($wpdb->last_error) {
            error_log(print_r($wpdb->last_query, true), 3, trailingslashit( dirname( dirname( __FILE__ ) ) ) . 'r6-styles/error_log');
            error_log($wpdb->last_error, 3, trailingslashit( dirname( dirname( __FILE__ ) ) ) . 'r6-styles/error_log');
        }

        wp_die();
    }

    // This function updates the file status in the database.
    public static function file_status_update() {

        // Get the database object, and include the wordpress prefix in the table name
        global $wpdb;
        $table_name = $wpdb->prefix . "r6_file_locking";
        $user = wp_get_current_user();

        $data = $_POST;

        $updated_status = array(
            'filename' => $data['file'],
            'time' => date('Y-m-d H:i:s', strtotime("+10 hours")),
            'locked' => $data['locked'],
            'user' => $user->user_login,
            'user_id' => $user->ID
        );

        error_log(print_r($updated_status, true), 3, trailingslashit( dirname( dirname( __FILE__ ) ) ) . 'r6-styles/error_log');

        // insert the data into the database
        echo json_encode($wpdb->replace($table_name, $updated_status, array(
            '%s', // filename
            '%s', // time
            '%s', // locked
            '%s', // user
            '%d', // user ID
        )));

        if ($wpdb->last_error) {
            error_log(print_r($wpdb->last_query, true), 3, trailingslashit( dirname( dirname( __FILE__ ) ) ) . 'r6-styles/error_log');
            error_log($wpdb->last_error, 3, trailingslashit( dirname( dirname( __FILE__ ) ) ) . 'r6-styles/error_log');
        }

        wp_die();
    }

    public static function file_status_get() {
        // Get the database object, and include the wordpress prefix in the table name
        global $wpdb;
        $table_name = $wpdb->prefix . "r6_file_locking";

        $data = $_GET;

        echo json_encode($wpdb->get_row( "SELECT ".
                                         'filename,'.
                                         'time,'.
                                         'locked,'.
                                         'user,'.
                                         'user_id'.
                                         " FROM {$table_name} WHERE filename = '{$data['file']}'", ARRAY_A ));

        if ($wpdb->last_error) {
            error_log(print_r($wpdb->last_query, true), 3, trailingslashit( dirname( dirname( __FILE__ ) ) ) . 'r6-styles/error_log');
            error_log($wpdb->last_error, 3, trailingslashit( dirname( dirname( __FILE__ ) ) ) . 'r6-styles/error_log');
        }

        wp_die();
    }
}

add_action( 'wp_ajax_file_status_insert', ['R6_Styles_Database', 'file_status_insert'] );
add_action( 'wp_ajax_nopriv_file_status_insert', ['R6_Styles_Database', 'file_status_insert'] );

add_action( 'wp_ajax_file_status_update', ['R6_Styles_Database', 'file_status_update'] );
add_action( 'wp_ajax_nopriv_file_status_update', ['R6_Styles_Database', 'file_status_update'] );

add_action( 'wp_ajax_file_status_get', ['R6_Styles_Database', 'file_status_get'] );
add_action( 'wp_ajax_nopriv_file_status_get', ['R6_Styles_Database', 'file_status_get'] );
