(function ($) {
//Toggle Header
    $('.awb-oc-menu-item-link').on('click', function() {
        var toggletxt = $(this).find('.fusion-button-text-left').text();
        if (toggletxt === 'Open') {
            $(this).find('.fusion-button-text-left').text('Close');
        } else {
            $(this).find('.fusion-button-text-left').text('Open');
        }
    });
// Logo Slider
    new Swiper('.logo-sec', {
      spaceBetween: 0,
      centeredSlides: true,
      speed: 2000,
      autoplay: {
        delay: 1,
      },
      loop: true,
      slidesPerView:'auto',
      allowTouchMove: false,
      disableOnInteraction: true
    });
// Draggable slider section    
    const initSlider = (selector, options = {}) => {
    const sliderContainers = document.querySelectorAll(selector);
        if (sliderContainers.length) {
            sliderContainers.forEach(container => {
                const slider = container.querySelector('.swiper-container');
                const paging = container.querySelector('.js-paging');
                let prev;
                let next;            
                if (paging) {
                    prev = paging.querySelector('.js-paging-prev');
                    next = paging.querySelector('.js-paging-next');
                }            
                const swiper = new Swiper (slider, {
                    loop: false,
                    speed: 1000,
                    slidesPerView: 'auto',
                    spaceBetween: 74,
                    grabCursor: true,
                    slidesOffsetAfter: 0,
                    breakpoints: {
                        768: {
                            slidesPerView: 'auto',
                            spaceBetween: 90,
                            freeMode: true,
                            slidesOffsetAfter: 200
                        }
                    },
                    on: {
                        slideChange: function() {
                            setTimeout(function () {
                                swiper.params.touchReleaseOnEdges = false;  
                                swiper.params.mousewheel.releaseOnEdges = false;
                            });
                        },
                        reachEnd: function() {
                            setTimeout(function () {
                                swiper.params.touchReleaseOnEdges = true;
                                swiper.params.mousewheel.releaseOnEdges = true;
                            }, 500);
                        },
                        reachBeginning: function() {
                            setTimeout(function () {
                                swiper.params.touchReleaseOnEdges = true;
                                swiper.params.mousewheel.releaseOnEdges = true;
                            }, 500);
                        }
                    }
                });            
                next.addEventListener('click', () => {
                    swiper.slideNext(500);
                });
                prev.addEventListener('click', () => {
                    swiper.slidePrev(500);
                });            
                // Used for animations on slider dragging
                swiper.on('touchMove', ({el}) => {
                    el.classList.add('dragged');
                });                
                swiper.on('touchEnd', ({el}) => {
                    el.classList.remove('dragged');
                });
            });
        }
    };    
    initSlider('.js-slider');    
// Drag Cursor
    // set the starting position of the cursor outside of the screen
    let clientX = 0;
    let clientY = 0;
    let lastX = 0;
    let lastY = 0;
    const cursor = document.querySelector('.cursor');
    const section = document.querySelector('.slider');    
    // Show/hide the cursor when it is over the section
    if (section) {
        section.addEventListener('mouseenter', () => {
            cursor.classList.add('visible');
        });    
        section.addEventListener('mouseleave', () => {
            cursor.classList.remove('visible');
        });
    }    
    // function for linear interpolation of values
    const lerp = (a, b, n) => {
        return (1 - n) * a + n * b;
    };    
    const initCursor = () => {
        if (!cursor) return;    
        // add listener to track the current mouse position
        document.addEventListener('mousemove', e => {
            clientX = e.clientX;
            clientY = e.clientY;
        });    
        // transform the cursor to the current mouse position
        // use requestAnimationFrame() for smooth performance
        const render = () => {
            // lesser delta, greater the delay that the custom cursor follows the real cursor
            const delta = 0.1;
            lastX = lerp(lastX, clientX, delta);
            lastY = lerp(lastY, clientY, delta);        
            cursor.style.transform = `translate(${lastX}px, ${lastY}px)`;        
            requestAnimationFrame(render);
        };        
        requestAnimationFrame(render);
    };    
    initCursor();    
// Animation    
    function handleLoad() {       
        $('.page-banner').addClass('animate');        
    }    
    // Function to check if an element is in the half viewport
    function isInHalfViewport(element) {
        const rect = element.getBoundingClientRect();
        const viewportHeight = (window.innerHeight || document.documentElement.clientHeight);
        return rect.bottom >= viewportHeight / 2 && rect.top <= viewportHeight / 2;
    }       
    // Function to check if an element is in the start viewport
    function isInViewport(elementstart) {
        const rect = elementstart.getBoundingClientRect();
        //const viewportTop = 0; 
        const viewportHeight = (window.innerHeight || document.documentElement.clientHeight);        
        return rect.bottom >= viewportHeight / 8 && rect.top <= viewportHeight / 4;
    }      
    // Function to handle scroll event
    function handleScroll() {        
        // Home Banner Animation
        var topPos = $(this).scrollTop();
        if (topPos > 300) {
            $('.page-banner').addClass('scroll-animate'); // Home Banner Animation        
            $('.page-banner').removeClass('animate');
        } else {
            $('.page-banner').removeClass('scroll-animate');            
            $('.page-banner').addClass('animate');
        }        
        // Home Section Below logo
        const elements = document.querySelectorAll('.up-down-sec');
        elements.forEach(element => {
            if (isInHalfViewport(element)) {
                element.classList.add('in-halfviewport');
            } else {
                element.classList.remove('in-halfviewport');
            }
        });
        // Header Dark Theme on light bg - Note: Put light-bg-sec class on lighter section
        const elementstarts = document.querySelectorAll('.light-bg-sec');
        elementstarts.forEach(elementstart => {
            if (isInViewport(elementstart)) {
                document.querySelector('.header-bar').classList.add('dark-theme-header');
            } else {
                document.querySelector('.header-bar').classList.remove('dark-theme-header');
            }
        });        
    }    
    // Attach load event listener
    window.addEventListener('load', handleLoad);    
    // Attach scroll event listener
    window.addEventListener('scroll', handleScroll);    
    // Initial check when the page loads
    document.addEventListener('DOMContentLoaded', handleScroll);
// About Team
    // Show the first tab and hide the rest
    
    // desktop version
    $('.member-desktop .member-info .tab-content:first-child').css('position', 'relative');    
    $('.member-desktop .member-name a').mouseover(function() {
        $('.member-desktop .member-info .tab-content:first-child').css('position', '');
        $('.member-desktop .member-name a').removeClass('active');
        $(this).addClass('active');
        $('.member-desktop .tab-content').removeClass('active');      
        var activeTab = $(this).attr('href');
            $(activeTab).addClass('active');            
        return false;
    });
    $('.member-desktop .member-name a').mouseleave(function() {
        //$('.member-desktop .member-info .tab-content:first-child').css('position', 'relative');
        //$('.member-desktop .tab-content').removeClass('active');              
        return false;
    });
    // mobile version
    $('.member-mobile .member-name a').on('click', function(e) {
        e.preventDefault();
        
        if($(this).hasClass('active')){
            $('.member-mobile .member-name a').removeClass('active');
            $('.member-mobile .tab-content').slideUp(1200);
        } else{
            $('.member-mobile .member-name a').removeClass('active');
            $('.member-mobile .tab-content').slideUp(1200);
            $(this).toggleClass('active').parent().next().slideToggle(1200);
        }
    });
    // Enquire
        $('textarea, input').focus(function() {
            $(this).parent().parent().find('label').addClass('focused');
        });
        $('textarea, input').blur(function() {
            $(this).parent().parent().find('label').removeClass('focused');
        });
        $('textarea, input').on('change', function() {
            var complete = $(this).attr('autocomplete');  
            if (complete !== '') {
                $(this).parent().parent().find('label').addClass('color-green');
            }
        });
    //Contact form redirect after submission
    document.addEventListener( 'wpcf7mailsent', function( event ) {
       location = '/thank-you';
    }, false );

})(jQuery);